/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;

public class AWGraphApplet
extends Applet {
    private Graphics bfr;
    private Image img;
    private static final int VERTICAL = 0;
    private static final int HORIZONTAL = 1;
    private static final int SOLID = 0;
    private static final int STRIPED = 1;
    private static final int DEBUG = 3;
    private static final int SHIFTBAR = 3;
    private static final String VERSION = "1.1";
    private String title;
    private String special = "Not yet defined";
    private Font font;
    private Font fontb;
    private FontMetrics fontmetrics;
    private int orientation;
    private int barsize;
    private int nbblocks;
    private String[] blabels;
    private int b_fontsize = 11;
    private int blockSpacing = 5;
    private int textVertSpacing = 0;
    private int nbvalues;
    private Color[] colors;
    private String[] vlabels;
    private int[] styles;
    private float[] max;
    private int valSpacing = 0;
    private int valWidth = 5;
    private float[][] values;
    private int maxLabelWidth = 0;
    private Color background_color = Color.white;
    private Color border_color = Color.white;
    private Color special_color = Color.gray;
    private Color backgraph_colorl = Color.decode("#F6F6F6");
    private Color backgraph_colorm = Color.decode("#EDEDED");
    private Color backgraph_colorh = Color.decode("#E0E0E0");

    public synchronized void start() {
        int i;
        this.special = this.getParameter("special");
        if (this.special == null) {
            this.special = "";
        }
        this.Log("Applet 1.1 ($Revision: 1.6 $) init");
        String s = this.getParameter("b_fontsize");
        if (s != null) {
            this.b_fontsize = Integer.parseInt(s);
        }
        this.title = this.getParameter("title");
        if (this.title == null) {
            this.title = "Chart";
        }
        if ((s = this.getParameter("nbblocks")) != null) {
            this.nbblocks = Integer.parseInt(s);
        }
        if ((s = this.getParameter("nbvalues")) != null) {
            this.nbvalues = Integer.parseInt(s);
        }
        if ((s = this.getParameter("blockspacing")) != null) {
            this.blockSpacing = Integer.parseInt(s);
        }
        if ((s = this.getParameter("valspacing")) != null) {
            this.valSpacing = Integer.parseInt(s);
        }
        if ((s = this.getParameter("valwidth")) != null) {
            this.valWidth = Integer.parseInt(s);
        }
        this.orientation = (s = this.getParameter("orientation")) == null ? 0 : (s.equalsIgnoreCase("horizontal") ? 1 : 0);
        s = this.getParameter("barsize");
        if (s != null) {
            this.barsize = Integer.parseInt(s);
        }
        if ((s = this.getParameter("background_color")) != null) {
            this.background_color = Color.decode("#" + s);
        }
        if ((s = this.getParameter("border_color")) != null) {
            this.border_color = Color.decode("#" + s);
        }
        if ((s = this.getParameter("special_color")) != null) {
            this.special_color = Color.decode("#" + s);
        }
        this.Log("bblocks " + this.nbblocks);
        this.Log("nbvalues " + this.nbvalues);
        this.Log("barsize " + this.barsize);
        this.font = new Font("Verdana,Arial,Helvetica", 0, this.b_fontsize);
        this.fontb = new Font("Verdana,Arial,Helvetica", 1, this.b_fontsize);
        this.fontmetrics = this.getFontMetrics(this.font);
        this.blabels = new String[this.nbblocks];
        this.vlabels = new String[this.nbvalues];
        this.styles = new int[this.nbvalues];
        this.max = new float[this.nbvalues];
        this.colors = new Color[this.nbvalues];
        this.values = new float[this.nbblocks][this.nbvalues];
        for (i = 0; i < this.nbvalues; ++i) {
            this.parseLabel(i);
            this.parseStyle(i);
            this.parseColor(i);
            this.parseMax(i);
        }
        for (int j = 0; j < this.nbblocks; ++j) {
            this.parsebLabel(j);
            this.parseValue(j);
        }
        for (i = 0; i < this.nbvalues; ++i) {
            if (this.max[i] <= 0.0f) {
                this.max[i] = 1.0f;
            }
            this.Log("max[" + i + "]=" + this.max[i]);
        }
    }

    private synchronized void Log(String s) {
        System.out.println(this.getClass().getName() + " (" + this.special + "): " + s);
    }

    private synchronized void parsebLabel(int i) {
        String s = this.getParameter("b" + (i + 1) + "_label");
        this.blabels[i] = s == null ? "" : s;
        this.maxLabelWidth = Math.max(this.fontmetrics.stringWidth(this.blabels[i]), this.maxLabelWidth);
    }

    private synchronized void parseLabel(int i) {
        String s = this.getParameter("v" + (i + 1) + "_label");
        this.vlabels[i] = s == null ? "" : s;
    }

    private synchronized void parseStyle(int i) {
        String s = this.getParameter("v" + (i + 1) + "_style");
        this.styles[i] = s == null || s.equalsIgnoreCase("solid") ? 0 : (s.equalsIgnoreCase("striped") ? 1 : 0);
    }

    private synchronized void parseColor(int i) {
        String s = this.getParameter("v" + (i + 1) + "_color");
        this.colors[i] = s != null ? Color.decode("#" + s) : Color.gray;
    }

    private synchronized void parseMax(int i) {
        String s = this.getParameter("v" + (i + 1) + "_max");
        this.max[i] = s != null ? Float.valueOf(s).floatValue() : 1.0f;
    }

    private synchronized void parseValue(int i) {
        String s = this.getParameter("b" + (i + 1));
        if (s != null) {
            String[] as = this.split(s, " ", 0);
            for (int j = 0; j < as.length; ++j) {
                this.values[i][j] = as[j].compareTo("?") == 0 ? 0.0f : Float.parseFloat(as[j]);
            }
        }
    }

    private String[] split(String s, String c, int iStart) {
        int i;
        Vector<String> v = new Vector<String>();
        boolean bFin = false;
        String sub = "";
        int iOld = i = iStart - 1;
        while (!bFin) {
            iOld = i;
            if ((i = s.indexOf(c, iOld + 1)) != -1) {
                sub = s.substring(iOld + 1, i);
            } else {
                sub = s.substring(iOld + 1, s.length());
                bFin = true;
            }
            v.addElement(sub);
        }
        String[] tabS = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            tabS[i] = (String)v.elementAt(i);
        }
        return tabS;
    }

    private String remove(String s, String c) {
        int i;
        Vector<String> v = new Vector<String>();
        boolean bFin = false;
        String sub = "";
        int iOld = i = -1;
        while (!bFin) {
            iOld = i;
            if ((i = s.indexOf(c, iOld + 1)) != -1) {
                sub = s.substring(iOld + 1, i);
            } else {
                sub = s.substring(iOld + 1, s.length());
                bFin = true;
            }
            v.addElement(sub);
        }
        sub = "";
        for (i = 0; i < v.size(); ++i) {
            sub = sub + (String)v.elementAt(i);
        }
        return sub;
    }

    public void init() {
        this.img = this.createImage(this.getSize().width, this.getSize().height);
        this.bfr = this.img.getGraphics();
    }

    public synchronized void paint(Graphics g) {
        this.bfr.setColor(this.background_color);
        this.bfr.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.bfr.setColor(this.border_color);
        this.bfr.drawRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.orientation == 1) {
            this.paintHorizontal(this.bfr);
        } else {
            this.paintVertical(this.bfr);
        }
        g.drawImage(this.img, 0, 0, this);
    }

    private synchronized void draw3DBar(Graphics g, int x, int y, float w, float h, int shift, Color color) {
        Polygon polygon = new Polygon();
        int width = new Float(w).intValue();
        int height = new Float(h).intValue();
        polygon.addPoint(x, y);
        polygon.addPoint(x + width, y);
        polygon.addPoint(x + width, y - height);
        polygon.addPoint(x, y - height);
        g.setColor(color);
        g.fillPolygon(polygon);
        g.setColor(color.darker());
        g.drawPolygon(polygon);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(x + width, y);
        polygon2.addPoint(x + width + shift, y - shift);
        polygon2.addPoint(x + width + shift, y - shift - height);
        polygon2.addPoint(x + width, y - height);
        g.setColor(color.darker());
        g.fillPolygon(polygon2);
        g.setColor(color.darker().darker());
        g.drawPolygon(polygon2);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(x, y - height);
        polygon3.addPoint(x + width, y - height);
        polygon3.addPoint(x + width + shift, y - height - shift);
        polygon3.addPoint(x + shift, y - height - shift);
        g.setColor(color);
        g.fillPolygon(polygon3);
        g.setColor(color.darker());
        g.drawPolygon(polygon3);
    }

    private synchronized void paintHorizontal(Graphics g) {
    }

    private synchronized void paintVertical(Graphics g) {
        g.setColor(Color.black);
        g.setFont(this.font);
        int shift = 10;
        int allbarwidth = (this.nbvalues * (this.valWidth + this.valSpacing) + this.blockSpacing) * this.nbblocks;
        int allbarheight = this.barsize;
        int axepointx = (this.getSize().width - allbarwidth) / 2 - 2 * shift;
        int axepointy = this.getSize().height - 2 * this.fontmetrics.getHeight() - 2 - this.textVertSpacing;
        int cx = axepointx;
        int cy = axepointy;
        Polygon polygon = new Polygon();
        polygon.addPoint(cx, cy);
        polygon.addPoint(cx + allbarwidth + 3 * shift, cy);
        polygon.addPoint(cx + allbarwidth + 4 * shift, cy - shift);
        polygon.addPoint(cx + shift, cy - shift);
        g.setColor(this.backgraph_colorl);
        g.fillPolygon(polygon);
        g.setColor(Color.lightGray);
        g.drawPolygon(polygon);
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(cx, cy);
        polygon2.addPoint(cx + shift, cy - shift);
        polygon2.addPoint(cx + shift, cy - shift - this.barsize);
        polygon2.addPoint(cx, cy - this.barsize);
        g.setColor(this.backgraph_colorh);
        g.fillPolygon(polygon2);
        g.setColor(Color.lightGray);
        g.drawPolygon(polygon2);
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(cx + shift, cy - shift);
        polygon3.addPoint(cx + allbarwidth + 4 * shift, cy - shift);
        polygon3.addPoint(cx + allbarwidth + 4 * shift, cy - shift - this.barsize);
        polygon3.addPoint(cx + shift, cy - shift - this.barsize);
        g.setColor(this.backgraph_colorm);
        g.fillPolygon(polygon3);
        g.setColor(Color.lightGray);
        g.drawPolygon(polygon3);
        cx += 2 * shift;
        for (int j = 0; j < this.nbblocks; ++j) {
            int i;
            cy = this.getSize().height - this.fontmetrics.getHeight() - 3 - this.textVertSpacing;
            g.setColor(Color.black);
            boolean bold = false;
            boolean highlight = false;
            String label = this.blabels[j];
            if (this.blabels[j].indexOf(":") > 0) {
                bold = true;
                label = this.remove(this.blabels[j], ":");
            }
            if (this.blabels[j].indexOf("!") > 0) {
                highlight = true;
                label = this.remove(this.blabels[j], "!");
            }
            if (bold) {
                g.setFont(this.fontb);
            }
            String[] as = this.split(label, "\u00a7", 0);
            if (highlight) {
                g.setColor(this.special_color);
                g.fillRect(cx - Math.max(-1 + this.blockSpacing >> 1, 0), cy - this.fontmetrics.getHeight() + 2, this.nbvalues * (this.valWidth + this.valSpacing) + Math.max(this.blockSpacing - 2, 0) + 1, (this.fontmetrics.getHeight() + this.textVertSpacing) * as.length + 2);
                g.setColor(Color.black);
            }
            for (i = 0; i < as.length; ++i) {
                int cxoffset = this.nbvalues * (this.valWidth + this.valSpacing) - this.fontmetrics.stringWidth(as[i]) >> 1;
                if (cxoffset < 0) {
                    cxoffset = 0;
                }
                g.drawString(as[i], cx + cxoffset, cy);
                cy += this.fontmetrics.getHeight() + this.textVertSpacing - 1;
            }
            if (bold) {
                g.setFont(this.font);
            }
            for (i = 0; i < this.nbvalues; ++i) {
                cy = this.getSize().height - this.fontmetrics.getHeight() - 6 - this.textVertSpacing;
                this.draw3DBar(g, cx, cy -= this.fontmetrics.getHeight() - 4, this.valWidth, this.values[j][i] * (float)this.barsize / this.max[i], 3, this.colors[i]);
                cy = (int)((float)cy - (this.values[j][i] + 5.0f));
                cx += this.valWidth + this.valSpacing;
            }
            cx += this.blockSpacing;
        }
    }

    public synchronized String getAppletInfo() {
        return "Title: " + this.title + "\n";
    }

    public synchronized String[][] getParameterInfo() {
        String[][] as = new String[][]{{"version", "string", "AWGraphApplet 1.1"}, {"copyright", "string", "GPL"}, {"title", "string", this.title}};
        return as;
    }
}

